// Autor: Ivan Katanic

#include <algorithm>
#include <cstring>
#include <iostream>
#include <unordered_map>

using namespace std;

typedef long long llint;

const int MAX = 300300;

struct ValCounts {
  unordered_map<int, int> M;
  int sum_pos; // sum of absolute values

  void add(int x, int k) {
    sum_pos -= abs(M[x]);
    M[x] += k;
    sum_pos += abs(M[x]);
  }

  void swap(ValCounts& b) {
    M.swap(b.M);
    std::swap(sum_pos, b.sum_pos);
  }

  void merge(ValCounts& b) {
    for (auto&p : b.M)
      add(p.first, p.second);
  }
  
  int size() {
    return M.size();
  }
} s[MAX];

int a[MAX], b[MAX];
int L[MAX], R[MAX];

int p = 0;

llint solve(int x) {
  if (x == -1) return 0;
  
  llint ans = 0;
  ans += solve(L[x]);
  int need = b[p++];
  ans += solve(R[x]);

  int y1 = L[x], y2 = R[x];
  if (y1 == -1 || (y2 != -1 && s[y2].size() > s[y1].size())) swap(y1, y2);

  if (y1 != -1) s[x].swap(s[y1]);

  s[x].add(a[x], +1);
  s[x].add(need, -1);

  if (y2 != -1) s[x].merge(s[y2]);

  ans += s[x].sum_pos;
  return ans;
}

int main(void) {
  int n;
  scanf("%d", &n);
  for (int i = 0; i < n; ++i) {
    scanf("%d %d", &L[i], &R[i]);
    --L[i], --R[i];
  }
  for (int i = 0; i < n; ++i) {
    scanf("%d", &a[i]);
    b[i] = a[i];
  }

  sort(b, b + n);
  printf("%lld\n", solve(0));
  return 0;
}
